module Web = 

  let escapeUTF8ForXML s =
    let buf = Buffer.build (String.length s * 2) in 
    let f i = 
      let c = s.[i] in 
      if c = '&' || c = '<' || c = '>' then
        Buffer.add_string buf ("&#" ^ (sprintf "%i" (int_of_char c)) ^ ";")
      else
        Buffer.add_char buf c
      in 
    for 0 (String.length s - 1) f;
    Buffer.contents buf
      
      
  let base64chars = [|
'A';'B';'C';'D';'E';'F';'G';'H';'I';'J';'K';'L';'M';'N';'O';'P';
'Q';'R';'S';'T';'U';'V';'W';'X';'Y';'Z';'a';'b';'c';'d';'e';'f';
'g';'h';'i';'j';'k';'l';'m';'n';'o';'p';'q';'r';'s';'t';'u';'v';
'w';'x';'y';'z';'0';'1';'2';'3';'4';'5';'6';'7';'8';'9';'+';'/'; |]


  let buildBase64Table () = 
    let arr = Array.build 256 in 
    for 0 (Array.length base64chars) 
       (fun i -> let code = int_of_char base64chars[i] in 
                 arr[code] <- i);
    arr
  
  
  (*let encodeBase64 s = 
    let n = String.length s in 
    let arr = buildBase64Table () in 
    let buf = Buffer.build (String.length s * 2) in 
    ()*)

    
    
    
  let encodeBase64 input =
    let len = String.length input in
    let alphabet = buildBase64Table () in 
    let words = (len + 2) / 3 in 
    let padding_len = if len mod 3 = 0 then 0 else 3 - (len mod 3) in
    let output = String.build (words * 4) in
    let get i = if i >= len then 0 else int_of_char input.[i] in
    let f i = 
      let x = get (3 * i + 0) in 
      let y = get (3 * i + 1) in 
      let z = get (3 * i + 2) in
      let n = (x lsl 16) lor (y lsl 8) lor z in
      let a = (n lsr 18) land 0x3f in 
      let b = (n lsr 12) land 0x3f in 
      let c = (n lsr 6) land 0x3f in 
      let d = n land 0x3f in
      output.[4 * i + 0] <- base64chars[a];
      output.[4 * i + 1] <- base64chars[b];
      output.[4 * i + 2] <- base64chars[c];
      output.[4 * i + 3] <- base64chars[d]
     in 
    for  0  (words - 1)  f;
    
    for  1  padding_len  
       (fun i -> output.[String.length output - i] <- '=');
    
    output
  
  
  
let decodeBase64 s = (* garbage in, garbage out / no exception raised *)
  let n = String.length s in 
  let arr = buildBase64Table () in 
  let buf = Buffer.build (String.length s * 2) in 
  let a = ref 0 in 
  let f i = 
    let i1 = arr[int_of_char s.[i * 4]] in 
    let i2 = arr[int_of_char s.[i * 4 + 1]] in 
    let i3 = arr[int_of_char s.[i * 4 + 2]] in 
    let i4 = arr[int_of_char s.[i * 4 + 3]] in 
  
    a := i1 lsl (6 * 3) lor (i2 lsl (6 * 2)) lor (i3 lsl (6 * 1)) lor i4;
  
    let c1 = char_of_int (!a lsr (8 * 2)) in 
    let c2 = char_of_int (!a lsr (8 * 1) land 0xff) in 
    let c3 = char_of_int (!a land 0xff) in 
  
    Buffer.add_char buf c1;
    if c2 <> '\x00' then Buffer.add_char buf c2 else (); (* handle the padding *)
    if c3 <> '\x00' then Buffer.add_char buf c3 else ()
   in 
  for 0 (n / 4 - 1) f;
  Buffer.contents buf
  

endmodule